<?php
/**
* The template for displaying page
* template name: Home Template
*
* @package TSS technology
* @since TSS technology 1.0
*/

get_header();
?>	<!-- BANNER -->
	<?php $args = array('post_type'=>'slider');
		  $qr = new WP_Query($args);
		  if($qr->have_posts()) {
	 ?>
	<div id="slides" class="section banner">
		<ul class="slides-container">
			<?php while($qr->have_posts()){ $qr->the_post(); 

				$content = get_the_content();

				$img_url = wp_get_attachment_url(get_post_thumbnail_id($get_post_thumbnail_id->ID),'full');
			?>
			<li>
				<img src="<?php echo $img_url; ?>" alt="">
				<div class="overlay-bg"></div>
				<div class="container">
					<div class="wrap-caption">
						<h2 class="caption-heading">
							<?php the_title(); ?>
						</h2>
						<p class="excerpt"><?php echo $content; ?></p>
					</div>
				</div>
			</li>
			<?php } ?>
		</ul>

		<nav class="slides-navigation">
			<div class="container">
				<a href="#" class="next">
					<i class="fa fa-chevron-right"></i>
				</a>
				<a href="#" class="prev">
					<i class="fa fa-chevron-left"></i>
				</a>
	      	</div>
	    </nav>
		
	</div>
<?php } ?>

<!-- ABOUT FEATURE -->
	<div class="section feature overlap">
		<div class="container">
			<div class="row">
				<div class="col-sm-12 col-md-12">
					<h2 class="section-heading">
						  About Us
					</h2>
				</div>
			</div>
			<div class="row">
				<div class="col-sm-5 col-md-5">
					<div class="jumbo-heading">
						<?php $title = get_the_title(); ?>
						<h2>TTS Technology Egypt (TTS) is an Egyptian company.</h2>
						<span class="fa fa-paper-plane-o"></span>
					</div>
				</div>
				<div class="col-sm-7 col-md-7">
					<?php 
					the_post();
					the_content(); ?>
				</div>
				<div class="col-md-12 ">
					<a href="<?php echo home_url().'/about-us'; ?>" class="btn btn-primary pull-right"> more information </a>
				</div>
			</div>
		</div>
	</div>
	
<!-- Get with TTS  -->

<?php $args = array('post_type'=>'get_with_tts','posts_per_page'=>3);
	$qr = new WP_Query($args);
	if($qr->have_posts())
	{
 ?>
	<div class="section why">
		<div class="container">
			<div class="row">
				<div class="col-sm-12 col-md-12">
					<h2 class="section-heading">
						Get with TTS 
					</h2>
				</div>
			</div>


			<div class="row no-gutter">
				<?php while ($qr->have_posts()) { 
						$qr->the_post();
						$content = strip_tags(get_the_content());
				 ?>
				<div class="col-sm-6 col-md-4">
					<!-- BOX 1 -->
					<div class="box-icon-3">
						<div class="line-t"></div>
						<div class="icon">
							<div class="fa <?php echo the_field('icon'); ?>"></div>
						</div>
						<div class="body-content">
							<div class="heading"><?php the_title(); ?></div>
							<?php echo substr($content, 0, 60); ?>
							<a href="<?php echo get_permalink($post->ID); ?>" class="readmore">READ MORE</a>
						</div>
						<div class="line-b"></div>
					</div>
				</div>
				<?php } ?>		
				
			</div>

		</div>
	</div>

<!-- Start Patent -->
<?php } ?>
	<?php $args = array('post_type'=>'patent','posts_per_page'=>2);
	$qr = new WP_Query($args);
	if($qr->have_posts())
	{
 ?>	
<div class="section service section-border bglight">
		<div class="container">
			<div class="row">
				<div class="col-sm-12 col-md-12">
					<h2 class="section-heading">
						Patent 
					</h2>
				</div>
			</div>
			
			<div class="row grid-services">
				<?php while ($qr->have_posts()) { 
						$qr->the_post();
						$content = strip_tags(get_the_content());
						$img_url = wp_get_attachment_url(get_post_thumbnail_id($post->ID),'full');
				 ?>
				<div class="col-sm-6 col-md-6">
					<div class="box-image-4">
						<a href="<?php echo home_url().'/patent/'; ?>" title="Industrial Complex">
							<div class="media">
								<img src="<?php echo $img_url; ?>" alt="" class="img-responsive">
							</div>
							<div class="body">
								<div class="content">
									<!-- <h4 class="title"><?php the_title(); ?></h4> -->
									<!--<div class="widget download">
								<a href="<?php the_field('patent_pdf'); ?>" class="btn btn-secondary btn-block btn-sidebar">
										</div>-->
										
								<a href="<?php the_field('p_link'); ?>" class="btn btn-secondary btn-block btn-sidebar">
										Read More
									<!-- <span class="category"><?php the_field('category'); ?></span> -->
								</div>
							</div>
						</a>
					</div>
				</div>	
				<?php } ?>			
			</div>
		</div>
</div>
<?php } ?>
<!-- End Patent -->

<!-- case study -->
<?php $args = array('post_type'=>'case_study','posts_per_page'=>3);
	$qr = new WP_Query($args);
	if($qr->have_posts())
	{
 ?>
<div class="section feature overlap">
		<div class="container">
<div class="row">
				<div class="col-sm-12 col-md-12">
					<h2 class="section-heading p-b-0">
						Case Study 
					</h2>
				</div>
			</div>
			<div class="row"> 
				<?php while ($qr->have_posts()) { 
						$qr->the_post();
						$content = strip_tags(get_the_content());

					?>
				<div class="col-sm-4 col-md-4">
					<!-- BOX 1 -->
					<a href="<?php the_field('redirect_case_study_page'); ?>">
					<div class="box-icon-2">
						<div class="icon">
							<div class="fa <?php the_field('icon'); ?>"></div>
						</div>
					
						<div class="body-content">
							<div class="heading"><?php the_title(); ?></div>
							<?php echo substr($content, 0, 100).'...'; ?>
						</div>
					
					</div>
					</a>
				</div>
			<?php } ?>
				
			</div>
</div>
</div>
<?php } ?>

<!-- End case study -->
   
<!-- Activites -->

<?php 

	$args = array('post_type'=>'activites','posts_per_page'=>3);
	$qr = new WP_Query($args);
	if($qr->have_posts())
	{ 
	 ?>
	<div class="section service section-border bglight">
		<div class="container">
			<div class="row">
				<div class="col-sm-12 col-md-12">
					<h2 class="section-heading">
						Latest Activities 
					</h2>
				</div>
			</div>
			<div class="row">
				<?php while ($qr->have_posts()) {
					$qr->the_post();
					$content = strip_tags(get_the_content());
					$img_url = wp_get_attachment_url(get_post_thumbnail_id($post->ID),'full');
				 ?>
				<div class="col-sm-6 col-md-4">
					<!-- BOX 1 -->
					<div class="feature-box-8">
		              <div class="media">
		                <img src="<?php echo $img_url; ?>" alt="rud" class="img-responsive">
		              </div>
		              <div class="body">
		                <div class="icon-holder">
		                 <span class="fa <?php the_field('icon'); ?>"></span>
		                </div>
		                <a href="activities-detail.php" class="title"><?php the_title(); ?></a>
		                <p><?php echo substr($content, 0, 100); ?></p>
		                <a href="<?php echo get_permalink($post->ID); ?>" class="readmore">READ MORE</a>
		              </div>
		            </div>
				</div>
				<?php } ?>			
			</div>
		</div>
	</div>
	<?php } ?>
	<!-- End Activities -->

	<!-- Start Client --> 
	<?php 
	$args = array('post_type'=>'our_client');
	$qr = new WP_Query($args);
	if($qr->have_posts())
	{ 
	 ?>
	<div class="section testimony bglight">
		<div class="container"> 
			<div class="row"> 
				<div class="col-sm-12 col-md-12"> 
					<div class="row">
						<div class="col-sm-12 col-md-12">
							<h2 class="section-heading">
								Our clients / Our customers
							</h2>
						</div>
					</div>

					<div id="owl-testimony">
						<?php while ($qr->have_posts()) {
							$qr->the_post();
								$img_url = wp_get_attachment_url(get_post_thumbnail_id($post->ID),'full');
				 		?>
						<div class="item">
							<div class="testimonial-1">
				              <div class="media"><img src="<?php echo $img_url; ?>" alt="" class="img-responsive"></div>
				               
				            </div>
						</div>
						<?php } ?>
					</div>
				</div>
			</div>
		</div>
	</div>
<?php } ?>
<!-- End Client -->
<!-- Start Blog -->
	<?php 
	$args = array('post_type'=>'post','posts_per_page'=>3);
	$qr = new WP_Query($args);
	if($qr->have_posts())
	{ 
	 ?>
<div class="section">
		<div class="container">
			<div class="row">
				<h2 class="section-heading">
						Latest News 
					</h2>
					<?php while ($qr->have_posts()) {

								$qr->the_post();

								$img_url = wp_get_attachment_url(get_post_thumbnail_id($post->ID),'full');
								$post_date = get_the_date( 'l F j, Y' ); 
				 		?>
				<div class="col-sm-6 col-md-4">
					<!-- BOX 1 -->
					<div class="box-news-1">
						<div class="media gbr">
							<img src="<?php echo $img_url; ?>" alt="" class="img-responsive">
						</div>
						<div class="body">
							<div class="title"><a href="<?php echo get_permalink($post->ID); ?>" title=""><?php the_title(); ?></a></div>
							<div class="meta">
								<span class="date"><i class="fa fa-clock-o"></i> <?php echo $post_date; ?></span>
								<span class="comments"><i class="fa fa-comment-o"></i>  <?php comments_number( 'no comments', 'one comment', '% comments' ); ?></span>
							</div>
						</div>
					</div>
				</div>
			<?php } ?>

			</div>

			 
		</div>
	</div>
	<!-- End Blog -->
<?php } get_footer(); ?>