<?php
/**
* The template for displaying page
* template name: Activities Template
*
* @package TSS technology
* @since TSS technology 1.0
*/

get_header();
?>

<!-- BANNER -->

	<div class="section banner-page about">
		<div class="container">
			<div class="row">
				<div class="col-sm-12 col-md-12">
					<div class="title-page"><?php the_title(); ?></div>
					<ol class="breadcrumb">
						<li><a href="<?php home_url(); ?>">Home</a></li>
						<li class="active"><?php the_title(); ?></li>
					</ol>
				</div>
			</div>
		</div>
	</div>

 <?php 

	$args = array('post_type'=>'activites');

	$qr = new WP_Query($args);

	if($qr->have_posts())
	{ 

	 ?>
	<!-- Team -->
	<div class="section why overlap">
		<div class="container">
			<div class="row">
				<div class="col-sm-12 col-md-12">
					<h2 class="section-heading">
						<?php the_title(); ?>
					</h2>
				</div>
			</div>

			<div class="row">
				<?php while ($qr->have_posts()) {

					$qr->the_post();

					$content = get_the_content();

					$img_url = wp_get_attachment_url(get_post_thumbnail_id($post->ID),'full');
				 ?>
				<div class="col-sm-6 col-md-4">
					<!-- BOX 1 -->
					<div class="feature-box-8">
		              <div class="media">
		                <img src="<?php echo $img_url; ?>" alt="rud" class="img-responsive">
		              </div>
		              <div class="body">
		                <div class="icon-holder">
		                 <span class="fa <?php the_field('icon'); ?>"></span>
		                </div>
		                <a href="activities-detail.php" class="title"><?php the_title(); ?></a>
		                <p><?php echo substr($content, 0, 100); ?></p>
		                <a href="<?php echo get_permalink($post->ID); ?>" class="readmore">READ MORE</a>
		              </div>
		            </div>
				</div>
				<?php } ?>			
			</div>
		</div>
	</div>	
	<?php } ?>
	
	
<div class="section why overlap">
		<div class="container">
			<div class="row">
				<div class="col-sm-12 col-md-12">
					<h2 class="section-heading">
						VIDEO GALLERY
					</h2>
				</div>
			</div>

			<div class="row">
			    <?php
			    if(have_posts())
			    {
			        while(have_posts())
			        {
			            the_post();
			           
			            the_content();
			        }
			    }
			    ?>
				
		            
				</div>
						
			</div>
		</div>	
	
	
<?php get_footer(); ?>