<?php
/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package TTS-technology
 */

get_header();
?>
<div class="section banner-page about">
		<div class="container">
			<div class="row">
				<div class="col-sm-12 col-md-12">
					<div class="title-page"><?php the_title(); ?></div>
					<ol class="breadcrumb">
						<li><a href="<?php echo home_url(); ?>">Home</a></li>
						<li class="active"><?php the_title(); ?></li>
					</ol>
				</div>
			</div>
		</div>
	</div>
	<div class="section why overlap">
		<div class="container">
			<div class="row">
				
				<div class="col-sm-8 col-md-8">
					<div class="single-page">
						<?php $img_url = wp_get_attachment_url(get_post_thumbnail_id($post->ID),'full'); ?>
						<img src="<?php echo $img_url; ?>" alt="" class="img-responsive"> 
						<div class="margin-bottom-30"></div>
						<?php
						the_post();

						 the_content(); ?>
						 
					 </div>
				</div>
				<div class="col-sm-4 col-md-4">
					<div class="margin-bottom-30"></div>
					<div class="widget categories">
						<?php $args = array('post_type'=>'post');
							$qr = new WP_Query($args);
							if($qr->have_posts()){?>
						<ul class="category-nav">
							<?php 
							while ($qr->have_posts()) { 
							$qr->the_post();
							$content = get_the_content();
					 		?>
							<li class="active"><a href="<?php get_permalink($post->ID); ?>"><?php the_title(); ?></a></li>
							<?php }  ?>
						</ul>
						<?php } ?>
					</div> 
					<div class="widget download">
						<a href="#" class="btn btn-secondary btn-block btn-sidebar">
							<span class="fa  fa-file-pdf-o"></span> Company Brochure
						</a>
					</div>
 
					<?php $post_tags = get_the_tags();
 
						if ( $post_tags ) {
						    
						 ?>
					<div class="widget tags">
						<div class="widget-title">
							Tags
						</div>
						<div class="tagcloud">
							<?php foreach( $post_tags as $tag ) { ?>
							<a href="#" title="3 topics"><?php echo $tag->name; ?></a>
							<?php } ?>
						</div>
					</div>
					<?php } ?>		 				 
				</div>
			</div>
		</div>
		<div class="container">
			<div class="row">
			<?php if ( comments_open() || get_comments_number() ) :
				comments_template();
			endif;
 			?>
 			</div>	
		</div>
	</div>
	

<?php
get_footer();
