<?php
/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package TTS-technology
 */

get_header();
?>
<div class="section banner-page about">
		<div class="container">
			<div class="row">
				<div class="col-sm-12 col-md-12">
					<div class="title-page"><?php the_title(); ?></div>
					<ol class="breadcrumb">
						<li><a href="<?php echo home_url(); ?>">Home</a></li>
						<li class="active"><?php the_title(); ?></li>
					</ol>
				</div>
			</div>
		</div>
	</div>
	<div class="section why overlap">
		<div class="container">
			<div class="row">
				
				<div class="col-sm-8 col-md-8">
					<div class="single-page">
						<?php $img_url = wp_get_attachment_url(get_post_thumbnail_id($post->ID),'full'); ?>
						<img src="<?php echo $img_url; ?>" alt="" class="img-responsive"> 
						<div class="margin-bottom-30"></div>
						<?php
						the_post();

						 the_content(); ?>
						 
					 </div>
				</div>
				<div class="col-sm-4 col-md-4">
					<div class="margin-bottom-30"></div>
					<div class="widget categories">
						<?php $args = array('post_type'=>'get_with_tts');
							$qr = new WP_Query($args);
							if($qr->have_posts()){?>
						<ul class="category-nav">
							<?php 
							while ($qr->have_posts()) { 
							$qr->the_post();
							$content = get_the_content();
					 		?>
							<li class="active"><a href="<?php get_permalink($post->ID); ?>"><?php the_title(); ?></a></li>
							<?php }  ?>
						</ul>
						<?php } ?>
					</div> 

					 
								<h2 class="section-heading">
									What We Do
								</h2>
								<div class="section-subheading">Some of the problems that may be attributed to sludge deposition in storage tanks include. </div> 
								<ul class="checklist">
									<li>Loss of sludge entrapped hydrocarbons.</li>
									<li>Reduced tank holding capacity.</li>
									<li>Erroneous measurements of crude quantity.</li>
									<li>High sediment concentration is found in the oil located in the bottom of the tank, this causes troubles in desalting operation.</li>
									<li>Sludge build up may interfere with the roof floating operation.</li>
									<li>Tank drain plug problems may occur.</li>
									<li>Increased transfer pump maintenance due to impeller erosion and blockage, may become a problem</li>
									<li>Corrosion cell often assemble in the sludge zone</li>
								</ul>

								<h2 class="section-heading"> ADVANTAGES OF THE PROCESS</h2>

							 
								<ul class="checklist">
									<li>Time saving</li>
									<li>Economical and optimal</li>
									<li>No crude losses</li>
									<li>Closed circuit system</li>
									<li>No pollution</li>
									<li>No danger or damage to downstream system</li>
									<li>No toxic reactants, products or fumes</li>
									<li>Guaranteed success</li>
								</ul>
							 
					 
					 
				</div>
				

			</div>
		</div>
	</div>	

<?php

get_footer();
