<?php
/**
 * Functions which enhance the theme by hooking into WordPress
 *
 * @package TTS-technology
 */

/**
 * Adds custom classes to the array of body classes.
 *
 * @param array $classes Classes for the body element.
 * @return array
 */
function tts_technology_body_classes( $classes ) {
	// Adds a class of hfeed to non-singular pages.
	if ( ! is_singular() ) {
		$classes[] = 'hfeed';
	}

	// Adds a class of no-sidebar when there is no sidebar present.
	if ( ! is_active_sidebar( 'sidebar-1' ) ) {
		$classes[] = 'no-sidebar';
	}

	return $classes;
}
add_filter( 'body_class', 'tts_technology_body_classes' );

/**
 * Add a pingback url auto-discovery header for single posts, pages, or attachments.
 */
function tts_technology_pingback_header() {
	if ( is_singular() && pings_open() ) {
		echo '<link rel="pingback" href="', esc_url( get_bloginfo( 'pingback_url' ) ), '">';
	}
}
add_action( 'wp_head', 'tts_technology_pingback_header' );


function slider_register_post_type(){

	register_post_type('slider', array(
		'labels'=>array(
			'name'=>'Slider',
			'singuler_name'=>'slider',
			'add_new'=>'Add New',
			'edit_item'=>'Edit Slider',
			'search_item'=>'Search Slider',
			'not_found'=>'no slider found',
			'not_found_in_trash'=>'no slider found in trash',	
			
		),
		'public'=>true,
		'rewrite'=>array('slug'=>'slider'),
		'supports'=>array('title','editor','gallery','thumbnail')
	));
}

add_action('init','slider_register_post_type',0);

function get_with_tts_post_type(){
	register_post_type('get_with_tts',array(
		'labels'=>array(
			'name'=>'Get with tts',
			'singuler_name'=>'Get with tts',
			'add_new'=>	'Add New',
			'edit_item'=>'Edit Get With TTS',
			'search_item'=>'Search TTS',
			'not_found'	=>'no tts found',
			'not_found_in_trash'=>'no tts found in trash',
		),
		'public'=>true,
		'rewrite'=>array('slug'=>'get_with_tts'),
		'supports'=>array('title','editor','thumbnail','gallery','excerpt')
	));
}

add_action('init','get_with_tts_post_type',0);


function case_study_post_type(){
	register_post_type('case_study', array(
		'labels'=>array(
			'name'			=>'Case Study',
			'singuler_name' =>'Case study',
			'add_new'	    =>'Add New',
			'edit_item'		=>'Edit Case Study',
			'search_item'	=>'Search Case Study',
			'not_found'		=>'no case study found',
			'not_found_in_trash'=>'no case study found in trash',
		),
		'public'=>true,
		'rewrite'=>array('slug'=>'case_study'),
		'supports'=>array('title','editor','excerpt','thumbnail')		
	));
}
add_action('init','case_study_post_type',0);

function patent_post_type(){
	register_post_type('patent', array(
		'labels'=>array(
			'name'			=>'Patent',
			'singuler_name' =>'Patent',
			'add_new'	    =>'Add New',
			'edit_item'		=>'Edit Patent',
			'search_item'	=>'Search Patent',
			'not_found'		=>'no patent found',
			'not_found_in_trash'=>'no patent found in trash',
		),
		'public'=>true,
		'rewrite'=>array('slug'=>'patent'),
		'supports'=>array('title','editor','excerpt','thumbnail')		
	));
}
add_action('init','patent_post_type',0);

add_action('init','activites_post_type',0);

function activites_post_type(){
	register_post_type('activites', array(
		'labels'=>array(
			'name'			=>'Activites',
			'singuler_name' =>'Activites',
			'add_new'	    =>'Add New',
			'edit_item'		=>'Edit Activites',
			'search_item'	=>'Search Activites',
			'not_found'		=>'no activites found',
			'not_found_in_trash'=>'no activites found in trash',
		),
		'public'=>true,
		'rewrite'=>array('slug'=>'activites'),
		'supports'=>array('title','editor','excerpt','thumbnail')		
	));
}

add_action('init','our_client_post_type',0);

function our_client_post_type(){
	register_post_type('our_client', array(
		'labels'=>array(
			'name'			=>'Our client',
			'singuler_name' =>'Our client',
			'add_new'	    =>'Add New',
			'edit_item'		=>'Edit Our client',
			'search_item'	=>'Search Our client',
			'not_found'		=>'No Our client found',
			'not_found_in_trash'=>'No Our client found in trash',
		),
		'public'=>true,
		'rewrite'=>array('slug'=>'our_client'),
		'supports'=>array('title','editor','excerpt','thumbnail')		
	));
}

function registe_sidebar_tts()
{
	register_sidebar( array(
			'name'			=>'Footer sidebar one',
			'id'			=>'footer-sider-1',
			'before_widget' => '<div class="footer-item">',
        	'after_widget'  => '</div>',
        	'before_title'  => '<h2 class="widgettitle">',
        	'after_title'   => '</h2>',
	));

	register_sidebar(array(
			'name'			=>'Footer sidebar two',
			'id'			=>'footer-sider-2',
			'before_widget'	=>'<div class="footer-item">',
			'after_widget'	=>'</div>',
			'before_title'	=>'<h2 class="widgettitle>',
			'after_title'	=>'</h2>',
	));

	register_sidebar(array(
			'name'			=>'Footer sidebar three',
			'id'			=>'footer-sider-3',
			'before_widget'	=>'<div class="footer-item">',
			'after_widget'	=>'</div>',
			'before_title'	=>'<h2 class="widgettitle">',
			'after_title'	=>'</h2>',
	));

	register_sidebar(array(
			'name'			=>'Footer sidebar four',
			'id'			=>'footer-sider-4',
			'before_widget'	=>'<div class="footer-item">',
			'after_widget'	=>'</div>',
			'before_title'	=>'<h2 class="widgettitle">',
			'after_title'	=>'</h2>',
	));
}

add_action('widgets_init','registe_sidebar_tts');



if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'WPEX_Theme_Options' ) ) {

	class WPEX_Theme_Options {

		public function __construct() {
			if ( is_admin() ) {
				add_action( 'admin_menu', array( 'WPEX_Theme_Options', 'add_admin_menu' ) );
				add_action( 'admin_init', array( 'WPEX_Theme_Options', 'register_settings' ) );
			}

		}

	
		public static function get_theme_options() {
			return get_option( 'theme_options' );
		}

	
		public static function get_theme_option( $id ) {
			$options = self::get_theme_options();
			if ( isset( $options[$id] ) ) {
				return $options[$id];
			}
		}

		
		public static function add_admin_menu() {
			add_menu_page(
				esc_html__( 'Theme Settings', 'text-domain' ),
				esc_html__( 'Theme Settings', 'text-domain' ),
				'manage_options',
				'theme-settings',
				array( 'WPEX_Theme_Options', 'create_admin_page' )
			);
		}

		public static function register_settings() {
			register_setting( 'theme_options', 'theme_options', array( 'WPEX_Theme_Options', 'sanitize' ) );
		}

		public static function sanitize( $options ) {

			if ( $options ) {

				if ( ! empty( $options['mobile'] ) ) {
					$options['mobile'] = sanitize_text_field( $options['mobile'] );
				} else {
					unset( $options['mobile'] ); 
				}

				if ( ! empty( $options['email'] ) ) {
					$options['email'] = sanitize_text_field( $options['email'] );
				} else {
					unset( $options['email'] ); 
				}

				if ( ! empty( $options['address'] ) ) {
					$options['address'] = sanitize_text_field( $options['address'] );
				}
				if ( ! empty( $options['office_phone'] ) ) {
					$options['office_phone'] = sanitize_text_field( $options['office_phone'] );
				} else {
					unset( $options['office_phone'] ); 
				}
				if ( ! empty( $options['sales_email'] ) ) {
					$options['sales_email'] = sanitize_text_field( $options['sales_email'] );
				} else {
					unset( $options['sales_email'] );
				}

			}

			return $options;

		}

	
		public static function create_admin_page() { ?>
			<style>
				input[type="text"], input[type="tel"], input[type="email"], textarea{width: 250px;}
			</style>
			<div class="wrap">

				<h1><?php esc_html_e( 'Theme Options', 'text-domain' ); ?></h1>

				<form method="post" action="options.php">

					<?php settings_fields( 'theme_options' ); ?>

					<table class="form-table wpex-custom-admin-login-table">

						<tr valign="top">
							<th scope="row">Mobile</th>
							<td>
								<?php $value = self::get_theme_option( 'mobile' ); ?>
								<input type="text" name="theme_options[mobile]" value="<?php echo esc_attr( $value); ?>" >
							</td>
						</tr>

						<tr valign="top">
							<th scope="row">Office Phone</th>
							<td>
								<?php $value = self::get_theme_option( 'office_phone' ); ?>
								<input type="tel" name="theme_options[office_phone]" value="<?php echo esc_attr( $value ); ?>">	
							</td>
						</tr>

						<tr valign="top">
							<th scope="row">Email</th>
							<td>
								<?php $value = self::get_theme_option( 'email' ); ?>
								<input type="email" name="theme_options[email]" value="<?php echo esc_attr( $value ); ?>">
							</td>
						</tr>

						<tr valign="top">
							<th scope="row">Sales Email</th>
							<td>
								<?php $value = self::get_theme_option( 'sales_email' ); ?>
								<input type="email" name="theme_options[sales_email]" value="<?php echo esc_attr( $value ); ?>">	
							</td>
						</tr>

						<tr valign="top">
							<th scope="row">Address</th>
							<td>
								<?php $value = self::get_theme_option( 'address' ); ?>
								<textarea name="theme_options[address]"><?php echo esc_attr( $value ); ?></textarea>
								
								
							</td>
						</tr>
						

						

					</table>

					<?php submit_button(); ?>

				</form>

			</div>
		<?php }

	}
}
new WPEX_Theme_Options();

function myprefix_get_theme_option( $id = '' ) {
	return WPEX_Theme_Options::get_theme_option( $id );
}