<?php
/**
 * TTS-technology functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package TTS-technology
 */

if ( ! function_exists( 'tts_technology_setup' ) ) :
	/**
	 * Sets up theme defaults and registers support for various WordPress features.
	 *
	 * Note that this function is hooked into the after_setup_theme hook, which
	 * runs before the init hook. The init hook is too late for some features, such
	 * as indicating support for post thumbnails.
	 */
	function tts_technology_setup() {
		/*
		 * Make theme available for translation.
		 * Translations can be filed in the /languages/ directory.
		 * If you're building a theme based on TTS-technology, use a find and replace
		 * to change 'tts-technology' to the name of your theme in all the template files.
		 */
		load_theme_textdomain( 'tts-technology', get_template_directory() . '/languages' );

		// Add default posts and comments RSS feed links to head.
		add_theme_support( 'automatic-feed-links' );

		/*
		 * Let WordPress manage the document title.
		 * By adding theme support, we declare that this theme does not use a
		 * hard-coded <title> tag in the document head, and expect WordPress to
		 * provide it for us.
		 */
		add_theme_support( 'title-tag' );

		/*
		 * Enable support for Post Thumbnails on posts and pages.
		 *
		 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
		 */
		add_theme_support( 'post-thumbnails' );

		// This theme uses wp_nav_menu() in one location.
		register_nav_menus( array(
			'menu-1' => esc_html__( 'Primary', 'tts-technology' ),
		) );

		/*
		 * Switch default core markup for search form, comment form, and comments
		 * to output valid HTML5.
		 */
		add_theme_support( 'html5', array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
		) );

		// Set up the WordPress core custom background feature.
		add_theme_support( 'custom-background', apply_filters( 'tts_technology_custom_background_args', array(
			'default-color' => 'ffffff',
			'default-image' => '',
		) ) );

		// Add theme support for selective refresh for widgets.
		add_theme_support( 'customize-selective-refresh-widgets' );

		/**
		 * Add support for core custom logo.
		 *
		 * @link https://codex.wordpress.org/Theme_Logo
		 */
		add_theme_support( 'custom-logo', array(
			'height'      => 250,
			'width'       => 250,
			'flex-width'  => true,
			'flex-height' => true,
		) );
	}
endif;
add_action( 'after_setup_theme', 'tts_technology_setup' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function tts_technology_content_width() {
	// This variable is intended to be overruled from themes.
	// Open WPCS issue: {@link https://github.com/WordPress-Coding-Standards/WordPress-Coding-Standards/issues/1043}.
	// phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
	$GLOBALS['content_width'] = apply_filters( 'tts_technology_content_width', 640 );
}
add_action( 'after_setup_theme', 'tts_technology_content_width', 0 );

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function tts_technology_widgets_init() {
	register_sidebar( array(
		'name'          => esc_html__( 'Sidebar', 'tts-technology' ),
		'id'            => 'sidebar-1',
		'description'   => esc_html__( 'Add widgets here.', 'tts-technology' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );
}
add_action( 'widgets_init', 'tts_technology_widgets_init' );

/**
 * Enqueue scripts and styles.
 */
function tts_technology_scripts() {
	wp_enqueue_style( 'tts-technology-style', get_stylesheet_uri() );
	wp_enqueue_style('tts-technology-bootstrap-css',get_template_directory_uri().'/assets/css/vendor/bootstrap.min.css',false,NULL,'all');
	wp_enqueue_style('tts-technology-font-awosom-css',get_template_directory_uri().'/assets/css/vendor/font-awesome.min.css',false,NULL,'all');
	wp_enqueue_style('tts-technology-carousel-css',get_template_directory_uri().'/assets/css/vendor/owl.carousel.min.css',false,NULL,'all');
	wp_enqueue_style('tts-technology-default-css',get_template_directory_uri().'/assets/css/vendor/owl.theme.default.min.css',false,NULL,'all');
	wp_enqueue_style('tts-technology-magnific-css',get_template_directory_uri().'/assets/css/vendor/magnific-popup.css',false,NULL,'all');
	wp_enqueue_style('tts-technology-style-css',get_template_directory_uri().'/assets/css/style.css',false,NULL,'all');
	wp_enqueue_script('tts-technology-modernizr-js',get_template_directory_uri().'/assets/js/vendor/modernizr.min.js', false, NULL, true);
	wp_enqueue_script('tts-technology-jquery-js',get_template_directory_uri().'/assets/js/vendor/jquery.min.js', false, NULL, true);
	wp_enqueue_script( 'tts-technology-navigation', get_template_directory_uri().'/js/navigation.js', array(), '20151215', true );

	wp_enqueue_script( 'tts-technology-skip-link-focus-fix', get_template_directory_uri() . '/js/skip-link-focus-fix.js', array(), '20151215', true );
	wp_enqueue_script('tts-technology-bootstrap-js',get_template_directory_uri().'/assets/js/vendor/bootstrap.min.js', false, NULL, true);

	wp_enqueue_script('tts-technology-superslides',get_template_directory_uri().'/assets/js/vendor/jquery.superslides.js', false, NULL, true);
	wp_enqueue_script('tts-technology-carousel',get_template_directory_uri().'/assets/js/vendor/owl.carousel.js', false, NULL, true);
	wp_enqueue_script('tts-technology-hover-dropdown',get_template_directory_uri().'/assets/js/vendor/bootstrap-hover-dropdown.min.js', false, NULL, true);
	wp_enqueue_script('tts-technology-magnific-popup',get_template_directory_uri().'/jquery.magnific-popup.min.js', false, NULL, true);
	wp_enqueue_script('tts-technology-easings',get_template_directory_uri().'/assets/js/vendor/easings.js', false, NULL, true);
	wp_enqueue_script('tts-technology-isotope',get_template_directory_uri().'/assets/js/vendor/isotope.pkgd.min.js', false, NULL, true);
	wp_enqueue_script('tts-technology-validator',get_template_directory_uri().'/assets/js/vendor/validator.min.js', false, NULL, true);
	wp_enqueue_script('tts-technology-form-scripts',get_template_directory_uri().'/assets/js/vendor/form-scripts.js', false, NULL, true);
	wp_enqueue_script('tts-technology-form-google','https://maps.google.com/maps/api/js?sensor=false', false, NULL, true);
	wp_enqueue_script('tts-technology-script-js',get_template_directory_uri().'/assets/js/script.js',false, NULL, true);

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'tts_technology_scripts' );

/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/inc/custom-header.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Functions which enhance the theme by hooking into WordPress.
 */
require get_template_directory() . '/inc/template-functions.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';

/**
 * Load Jetpack compatibility file.
 */
if ( defined( 'JETPACK__VERSION' ) ) {
	require get_template_directory() . '/inc/jetpack.php';
}

